# -*- coding: utf-8 -*-
"""
Created on Tue Oct 27 17:11:54 2015

"""

import numpy
from CLinearDiscretisation import CLinearDiscretisation

class CDomain:

    def __init__(self):
        self.X = CLinearDiscretisation()
        self.Y = CLinearDiscretisation()
        self.Time = CLinearDiscretisation()
            
    def Discretise(self,AMin,AMax,AStep):
        return numpy.zeros(range(AMin,AMax,AStep),float)
        
    def GetDuration(self):
        return self.Time.PhysicalSize()

    def GetLength(self):
        return self.XMax.PhysicalSize()
        
    def GetWidth(self):
        return self.YMax.PhysicalSize()
        
    def PrintToConsole(self):
        print ( 'Domain parameters')
        print ( '-----------------')
        print ( 'Time step (s) %5.2f.' % self.Time.Step)
        print ( 'X step (m) %5.2f.' % self.X.Step)
        print ( 'Y Step (m) %5.2f.' % self.Y.Step)
        print ( '')
        
    def SetupTimeSubdomain(self,ARiverVelocity):
        x_max = self.X.Max
        t_max = x_max/ARiverVelocity
        
        x_step = self.X.Step
        t_step = x_step/ARiverVelocity
        
        self.Time.Setup(0,t_max,t_step)
        
        
        